CREATE TABLE APDOPOST (
       apdo_id              SERIAL NOT NULL,
       cod_post             NUMERIC(10,0),
       ciudad               VARCHAR(20),
       pais                 VARCHAR(20),
       localidad            VARCHAR(50),
       municipio            VARCHAR(50),
       apdo_post            NUMERIC(10,0)
);

CREATE UNIQUE INDEX XPKAPDOPOST ON APDOPOST
(
       apdo_id 
);

ALTER TABLE APDOPOST
       ADD PRIMARY KEY (apdo_id);

CREATE TABLE DATOSDEPEN (
       dep_id               SERIAL NOT NULL,
       nom_int              VARCHAR(100) NOT NULL,
       siglas_inst          VARCHAR(20),
       nom_depen            VARCHAR(150),
       siglas_depen         VARCHAR(10),
       nom_subDepen         CHAR(150),
       ano_fundacion        NUMERIC(4,0),
       pag_web              VARCHAR(100),
       Observaciones        VARCHAR(1000),
       dep_Obs              VARCHAR(1000)
);

CREATE UNIQUE INDEX XPKDATOSDEPEN ON DATOSDEPEN
(
       dep_id
);


ALTER TABLE DATOSDEPEN
       ADD PRIMARY KEY (dep_id);

CREATE TABLE DATOSUBDEP (
       subdep_id            SERIAL NOT NULL,
       dep_id		    integer not null,
       nom_subdepen         VARCHAR(150),
       subdepen_siglas      VARCHAR(10),
       subdepen_ano_fundacion NUMERIC(4,0),
       subdepen_pag_web     VARCHAR(100),
       Observaciones        VARCHAR(1000),
       subdepen_Obs         VARCHAR(1000)
);

CREATE UNIQUE INDEX XPKDATOSUBDEP ON DATOSUBDEP
(
       subdep_id,  dep_id 
       
);


ALTER TABLE DATOSUBDEP
       ADD PRIMARY KEY (subdep_id, dep_id);

CREATE TABLE DATOSBIBLIO (
       bib_id               SERIAL NOT NULL,
       nombre               VARCHAR(200),
       nombre_abrev         VARCHAR(50),
       adscripcion          VARCHAR(100),
       subsistema           CHAR(100),
       ano_fundacion        NUMERIC(4,0),
       ref_historica        VARCHAR(500),
       pag_web              VARCHAR(100),
       control_dgb          VARCHAR(30),
       control_lc           VARCHAR(30),
       control_hx           VARCHAR(30),
       categoria            VARCHAR(20),
       cod_prog_lib         VARCHAR(50),
       cod_prog_rev         VARCHAR(50),
       prep_asig521         DECIMAL(9,2),
       prep_ejer521         DECIMAL(9,2),
       prep_asig523         DECIMAL(9,2),
       prep_ejer523         DECIMAL(9,2),
       prep_asig421         DECIMAL(9,2),
       prep_ejer421         DECIMAL(9,2),
       prep_enc_asig        DECIMAL(9,2),
       prep_enc_ejer        DECIMAL(9,2),
       superficie           DECIMAL(9,2),
       Observaciones        VARCHAR(1000),
       datospropBib_Obs     VARCHAR(1000),
       Status               VARCHAR(25),
       Spnosis              VARCHAR(3000)
);

CREATE UNIQUE INDEX XPKDATOSBIBLIO ON DATOSBIBLIO
(
       bib_id

);


ALTER TABLE DATOSBIBLIO
       ADD PRIMARY KEY (bib_id);

CREATE TABLE DIRECCION (
       dir_id               INTEGER NOT NULL,
       bib_id               INTEGER NOT NULL,
       dep_id               INTEGER NOT NULL,
       subdep_id            INTEGER NOT NULL,
       calle                VARCHAR(100),
       localidad            VARCHAR(80),
       municipio            VARCHAR(80),
       ciudad               VARCHAR(80),
       estado               VARCHAR(50),
       pais                 VARCHAR(80),
       apdo_id              INTEGER,
       cod_post             NUMERIC(10,0),
       Observaciones        VARCHAR(1000),
       dir_Obs              VARCHAR(1000)
);

CREATE UNIQUE INDEX XPKDIRECCION ON DIRECCION
(
       dir_id ,
       bib_id ,
       dep_id ,
       subdep_id
);


ALTER TABLE DIRECCION
       ADD PRIMARY KEY (dir_id, bib_id, dep_id, subdep_id);


CREATE TABLE COLECCION (
       bib_id               INTEGER NOT NULL,
       num_tit_lib          NUMERIC(10,0),
       num_vol_lib          NUMERIC(10,0),
       num_tit_rev          NUMERIC(10,0),
       num_fasc_rev         NUMERIC(10,0),
       num_tit_tes          NUMERIC(10,0),
       num_vol_tes          NUMERIC(10,0),
       otros_mat_doc        VARCHAR(1000),
       num_usuarios         NUMERIC(10,0),
       num_asistentes       NUMERIC(10,0),
       pub_editadas         VARCHAR(2000),
       clasif_conacyt       VARCHAR(1000),
       cobert_geogra        VARCHAR(25),
       descriptores         VARCHAR(500),
       descript_entidad     VARCHAR(2500),
       idioma               VARCHAR(300),
       sist_clasif          VARCHAR(250),
       Observaciones        VARCHAR(1000),
       Colec_Obs            VARCHAR(1000)
);

CREATE UNIQUE INDEX XPKCOLECCION ON COLECCION
(
       bib_id 
);


ALTER TABLE COLECCION
       ADD PRIMARY KEY (bib_id);

CREATE TABLE DATOSPERSONA (
       per_id               SERIAL NOT NULL,
       grado                VARCHAR(15),
       nombre               VARCHAR(75),
       tel_1                VARCHAR(75),
       tel_2                VARCHAR(75),
       tel_3                VARCHAR(75),
       fax_1                VARCHAR(75),
       fax_2                VARCHAR(75),
       mail_1               VARCHAR(80),
       mail_2               VARCHAR(80),
       horario              VARCHAR(150),
       Observaciones        VARCHAR(1000),
       per_Obs              VARCHAR(1000)
);

CREATE UNIQUE INDEX XPKDATOSPERSONA ON DATOSPERSONA
(
       per_id
);


ALTER TABLE DATOSPERSONA
       ADD PRIMARY KEY (per_id);

CREATE TABLE INFRAESTRUCTURA (
       bib_id               INTEGER NOT NULL,
       num_cpu              NUMERIC(4,0),
       num_term             NUMERIC(4,0),
       num_impr             NUMERIC(4,0),
       num_serv             NUMERIC(4,0),
       sw                   VARCHAR(2000),
       activ_autom          VARCHAR(1000),
       Observaciones        VARCHAR(1000),
       infra_Obs            VARCHAR(1000)
);

CREATE UNIQUE INDEX XPKINFRAESTRUCTURA ON INFRAESTRUCTURA
(
       bib_id
);


ALTER TABLE INFRAESTRUCTURA
       ADD PRIMARY KEY (bib_id);


CREATE TABLE NORMATIVIDAD (
       bib_id               INTEGER NOT NULL,
       comision             VARCHAR(2),
       reglamento           VARCHAR(2),
       manuales             VARCHAR(200),
       Observaciones        VARCHAR(1000),
       norm_Obs             VARCHAR(1000)
);

CREATE UNIQUE INDEX XPKNORMATIVIDAD ON NORMATIVIDAD
(
       bib_id
);


ALTER TABLE NORMATIVIDAD
       ADD PRIMARY KEY (bib_id);

CREATE TABLE PERSONA (
       bib_id               INTEGER NOT NULL,
       per_id               INTEGER NOT NULL,
       cargo                INTEGER NOT NULL
);

CREATE UNIQUE INDEX XPKPERSONA ON PERSONA
(
       bib_id ,
       per_id
);


ALTER TABLE PERSONA
       ADD PRIMARY KEY (bib_id, per_id);

CREATE TABLE RECHUMANOS (
       bib_id               INTEGER NOT NULL,
       academicos           NUMERIC(4,0),
       admvos               NUMERIC(4,0),
       honorarios           NUMERIC(3,0),
       total                NUMERIC(6,0),
       Observaciones        VARCHAR(1000),
       rechum_Obs           VARCHAR(1000)
);

CREATE UNIQUE INDEX XPKRECHUMANOS ON RECHUMANOS
(
       bib_id
);


ALTER TABLE RECHUMANOS
       ADD PRIMARY KEY (bib_id);

CREATE TABLE SERVICIO (
       bib_id               INTEGER NOT NULL,
       horario              VARCHAR(100) NOT NULL,
       t_acceso_acervo      VARCHAR(10),
       t_matdoc_prest       VARCHAR(2000),
       servs_especial       VARCHAR(2000),
       t_fuentes_impr       VARCHAR(2000),
       t_fuentes_elec       VARCHAR(2000),
       servicios            VARCHAR(2000),
       t_prestamo           VARCHAR(1000),
       inst_usuario         VARCHAR(2000),
       acceso_internet      VARCHAR(2),
       acceso_redunam       VARCHAR(2),
       acceso_bd_dgb        VARCHAR(2),
       Observaciones        VARCHAR(1000),
       serv_Obs             VARCHAR(1000)
);

CREATE UNIQUE INDEX XPKSERVICIO ON SERVICIO
(
       bib_id
);


ALTER TABLE SERVICIO
       ADD PRIMARY KEY (bib_id);

CREATE TABLE USUARIO (
       usu_id               SERIAL NOT NULL,
       area                 INTEGER NOT NULL,
       usu_Login            VARCHAR(20),
       usu_Passwd           VARCHAR(20)
);

CREATE UNIQUE INDEX XPKUSUARIO ON USUARIO
(
       usu_id
);


ALTER TABLE USUARIO
       ADD PRIMARY KEY (usu_id);


CREATE TABLE Modificacion (
       mod_id               SERIAL NOT NULL,
       mod_id_tabla         INT,
       mod_tabla            CHAR(30),
       mod_fecha            CHAR(50),
       mod_area             INT
);

CREATE UNIQUE INDEX XPKModificacion ON Modificacion
(
       mod_id 
);


ALTER TABLE Modificacion
       ADD PRIMARY KEY (mod_id);


ALTER TABLE COLECCION
       ADD FOREIGN KEY (bib_id)
                             REFERENCES DATOSBIBLIO  (bib_id)
                             ON DELETE RESTRICT
                             ON UPDATE RESTRICT;

ALTER TABLE DIRECCION
       ADD FOREIGN KEY (apdo_id)
                             REFERENCES APDOPOST  (apdo_id)
                             ON DELETE SET NULL
                             ON UPDATE SET NULL;


ALTER TABLE DIRECCION
       ADD FOREIGN KEY (dep_id)
                             REFERENCES DATOSDEPEN  (dep_id)
                             ON DELETE RESTRICT
                             ON UPDATE RESTRICT;


ALTER TABLE DIRECCION
       ADD FOREIGN KEY (bib_id)
                             REFERENCES DATOSBIBLIO  (bib_id)
                             ON DELETE RESTRICT
                             ON UPDATE RESTRICT;

ALTER TABLE DIRECCION
       ADD FOREIGN KEY (subdep_id)
                             REFERENCES DATOSUBDEP  (subdep_id)
                             ON DELETE RESTRICT
                             ON UPDATE RESTRICT;

ALTER TABLE INFRAESTRUCTURA
       ADD FOREIGN KEY (bib_id)
                             REFERENCES DATOSBIBLIO  (bib_id)
                             ON DELETE RESTRICT
                             ON UPDATE RESTRICT;


ALTER TABLE NORMATIVIDAD
       ADD FOREIGN KEY (bib_id)
                             REFERENCES DATOSBIBLIO  (bib_id)
                             ON DELETE RESTRICT
                             ON UPDATE RESTRICT;

ALTER TABLE PERSONA
       ADD FOREIGN KEY (per_id)
                             REFERENCES DATOSPERSONA  (per_id)
                             ON DELETE RESTRICT
                             ON UPDATE RESTRICT;

ALTER TABLE RECHUMANOS
       ADD FOREIGN KEY (bib_id)
                             REFERENCES DATOSBIBLIO  (bib_id)
                             ON DELETE RESTRICT
                             ON UPDATE RESTRICT;


ALTER TABLE SERVICIO
       ADD FOREIGN KEY (bib_id)
                             REFERENCES DATOSBIBLIO  (bib_id)
                             ON DELETE RESTRICT
                             ON UPDATE RESTRICT;
ALTER TABLE DATOSUBDEP
	 ADD FOREIGN KEY (dep_id)
                             REFERENCES DATOSDEPEN  (dep_id)
                             ON DELETE RESTRICT
                             ON UPDATE RESTRICT;
